VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_PrdManual"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

#If ENV = LIVE Then
Private mo_Db As Object
#Else
Private mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private mo_Tools As DPC_Tools

Private ml_U_Code As Long
Private ms_Language_Code As String

Public PRD_Id As String
Public CURR_Code As String
Public PRD_Code As String
Public PRD_CodeC As String
Public CT_Code As String
Public COF_Id As String
Public LEN_Id As Long
Public OFD_WshDat As Date
Public OFD_ShpDat As Date
Public OFD_DelDat As Date
Public OFD_Pos As Long
Public OFD_PosCus As String
Public OFD_PU As Long
Public SAE_Id As Long
Public SHP_Id As Long
Public VEN_Id As String
Public SAE_Name As String
Public SHP_Name As String
Public VEN_Name As String
Public OFD_IsAsItem As Boolean
Public OFD_IsFree As Boolean
Public PRD_ModA As Double
Public PRD_ModB As Double
Public PRD_NWgh As Double
Public MAT_Id As Long
Public MAT_Name As String
Public STA_Id As Long

Public OfferPrice As New Collection


Private Const C_ERRORRAISE As Long = 2500

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Property Let U_Code(al_Code As Long)
On Error GoTo ErrHandler
  
  ml_U_Code = al_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("U_Code.Let")
End Property

Property Let Language_Code(AString As String)
On Error GoTo ErrHandler
  
  ms_Language_Code = AString
  Exit Property
ErrHandler:
  Call ErrorHandler("Language_Code.Let")
End Property

Property Get Language_Code() As String
On Error GoTo ErrHandler
  
  Language_Code = ms_Language_Code
  Exit Property
ErrHandler:
  Call ErrorHandler("Language_Code.Get")
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
On Error GoTo ErrHandler
    
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Sub Load_A_COM()
On Error GoTo ErrHandler

  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_Com")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrHandler

  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_Com")
End Sub

Public Sub LoadOffer(ByVal as_COF_Id As String, ByVal as_OFD_IdPar As String)
On Error GoTo ErrHandler

Dim lc_Cursor As Long
Dim ls_req As String
Dim ls_PRD_Name  As String, ls_DOF_Value As String, ls_DOF_Name As String
Dim ll_Idx As Long, ll_RowIndex As Long, ll_Order As Long, ll_SepPos As Long
Dim lo_Offer As DPC_OfferPos

  ls_req = "exec Cap_OfferDetail_lst2 $COF_Id$, $COF_Lang$, $OFD_Main$, $OFD_IdPar$, $OFD_Valid$, $OFD_Id$"
  ls_req = Replace(ls_req, "$COF_Id$", mo_Tools.SQLStr(as_COF_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Main$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_IdPar$", mo_Tools.SQLStr(as_OFD_IdPar), , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Valid$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$OFD_Id$", "NULL", , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  Call mo_Db.First(lc_Cursor)
  While Not mo_Db.EOF(lc_Cursor)
    Set lo_Offer = New DPC_OfferPos
    Set lo_Offer.Tools = mo_Tools
    Call lo_Offer.Init(0, 0, eDPCQtyType.qtPCS, 1, 0, 0)
    Call lo_Offer.ReadOfferPos(mo_Db, lc_Cursor)
    Call OfferPrice.Add(lo_Offer)
    Call mo_Db.Next(lc_Cursor)
  Wend
  Call mo_Db.Close(lc_Cursor)

  Set lo_Offer = GetOfferPos(eDPCOfferDetail.odManualPosition)
  PRD_Id = lo_Offer.PRD_Id
  OFD_Pos = lo_Offer.OFD_Pos
  OFD_PosCus = lo_Offer.OFD_PosCus
  PRD_Code = lo_Offer.PRD_Code
  PRD_CodeC = lo_Offer.PRD_CodeC
  OFD_WshDat = lo_Offer.OFD_WshDat
  OFD_ShpDat = lo_Offer.OFD_ShpDat
  OFD_DelDat = lo_Offer.OFD_DelDat
  VEN_Id = lo_Offer.VEN_Id
  SHP_Id = lo_Offer.SHP_Id
  VEN_Name = lo_Offer.VEN_Name
  SHP_Name = lo_Offer.SHP_Name
  COF_Id = lo_Offer.COF_Id
  OFD_IsFree = lo_Offer.OFD_IsFree
  OFD_IsAsItem = lo_Offer.OFD_IsAsItem
  OFD_PU = lo_Offer.OFD_PU
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadOffer")
End Sub

Public Function GetOfferPos(ByVal ae_DOF_Id As eDPCOfferDetail) As DPC_OfferPos
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos

  Set GetOfferPos = Nothing
  For Each lo_Offer In OfferPrice
    If lo_Offer.DOF_Id = ae_DOF_Id Then
      Set GetOfferPos = lo_Offer
      Exit Function
    End If
  Next
  Exit Function
ErrHandler:
  Call ErrorHandler("GetOfferPos")
End Function

Public Sub LoadPrdManual(ByVal as_PRD_Id As String)
On Error GoTo ErrHandler

Dim ls_req As String
Dim lc_Cursor As Long

  ls_req = "exec DPC_PrdManual_sel $PRD_Id$, $Language_Code$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(as_PRD_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  lc_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_req)
  If mo_Db.RowCount(lc_Cursor) = 1 Then
    PRD_Id = mo_Db.GetFields(lc_Cursor, "PRD_Id")
    PRD_ModA = mo_Db.GetFields(lc_Cursor, "PRD_ModA")
    PRD_ModB = mo_Db.GetFields(lc_Cursor, "PRD_ModB")
    PRD_NWgh = mo_Db.GetFields(lc_Cursor, "PRD_NWgh")
    MAT_Id = mo_Db.GetFields(lc_Cursor, "MAT_Id")
    MAT_Name = mo_Db.GetFields(lc_Cursor, "MAT_Name")
    STA_Id = mo_Db.GetFields(lc_Cursor, "STA_Id")
  End If
  Call mo_Db.Close(lc_Cursor)
  Exit Sub
ErrHandler:
  Call ErrorHandler("LoadPrdManual")
End Sub

Public Sub Insert()
On Error GoTo ErrHandler
  
  Call InsertPrdCommon
  Call InsertPrdManual
  Exit Sub
ErrHandler:
  Call ErrorHandler("Insert")
End Sub

Public Sub Update()
On Error GoTo ErrHandler
  
  'Call UpdatePrdCommon
  'Call UpdatePrdManual
  Exit Sub
ErrHandler:
  Call ErrorHandler("Update")
End Sub

Public Sub Drop()
On Error GoTo ErrHandler
  
  'Call DropPrdCommon
  Exit Sub
ErrHandler:
  Call ErrorHandler("Drop")
End Sub

Public Sub InsertPrdCommon()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdCommon_ins $PRD_Id$, $CAT_Id$, $PRD_IdPar$, $PRD_Child$, $PRD_Code$, $PRD_CodeC$,"
  ls_req = ls_req & "$Vendor_Id$, $LEV_Id$, $ERR_Type$, $IMG_Id$, $STA_Id$, NULL, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$CAT_Id$", mo_Tools.SqlIntKey(eDPCCategory.cgManualMetal), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_IdPar$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Child$", mo_Tools.SqlInt(0), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_Code$", mo_Tools.SQLStr(PRD_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_CodeC$", mo_Tools.SQLStr(PRD_CodeC), , , vbTextCompare)
  ls_req = Replace(ls_req, "$Vendor_Id$", mo_Tools.SqlStrKey(VEN_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LEV_Id$", mo_Tools.SqlInt(eDPCLevel.lvEngineered), , , vbTextCompare)
  ls_req = Replace(ls_req, "$ERR_Type$", mo_Tools.SqlInt(eDPCErrorType.etNone), , , vbTextCompare)
  ls_req = Replace(ls_req, "$IMG_Id$", "NULL", , , vbTextCompare)
  ls_req = Replace(ls_req, "$STA_Id$", mo_Tools.SqlIntKey(STA_Id), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdCommon")
End Sub

Public Sub InsertPrdManual()
On Error GoTo ErrHandler

Dim ls_req As String

  ls_req = "exec DPC_PrdManual_ins $PRD_Id$, $MAT_Id$, $PRD_ModA$, $PRD_ModB$, $PRD_NWgh$, $Z_Creator$"
  
  ls_req = Replace(ls_req, "$PRD_Id$", mo_Tools.SqlStrKey(PRD_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$MAT_Id$", mo_Tools.SqlIntKey(MAT_Id), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_ModA$", mo_Tools.SqlDbl(PRD_ModA), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_ModB$", mo_Tools.SqlDbl(PRD_ModB), , , vbTextCompare)
  ls_req = Replace(ls_req, "$PRD_NWgh$", mo_Tools.SqlDbl(PRD_NWgh), , , vbTextCompare)
  ls_req = ReplaceCommonPlaceholders(ls_req)
  Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_req)
  Exit Sub
ErrHandler:
  Call ErrorHandler("InsertPrdManual")
End Sub

Private Sub ResetInterfaceInfo(ByVal ao_Collection As Collection)
On Error GoTo ErrHandler

Dim lo_Offer As DPC_OfferPos
  
  For Each lo_Offer In ao_Collection
    Call lo_Offer.ResetInterfaceInfo
  Next
  Exit Sub
ErrHandler:
  Call ErrorHandler("ResetInterfaceInfo")
End Sub

Public Sub Copy()
On Error GoTo ErrHandler

  Call ResetInterfaceInfo(OfferPrice)
  PRD_Code = mo_Tools.GetNextID(mo_Db, "DPC_MAN_PRD_Code")
  PRD_Id = mo_Tools.GetNextID(mo_Db, "DPC_PrdManual")
  STA_Id = eDPCProductStatus.psNone
  Exit Sub
ErrHandler:
  Call ErrorHandler("Copy")
End Sub


Public Function GenerateOfferDetail() As Collection
On Error GoTo ErrHandler

Dim lo_Collection As New Collection
Dim lo_OfferMain As DPC_OfferPos
Dim lo_Offer As DPC_OfferPos

  Set lo_OfferMain = GetOfferPos(eDPCOfferDetail.odManualPosition)
  lo_OfferMain.OFD_Main = eDPCOfferDetailMain.odMain
  lo_OfferMain.PRD_Code = PRD_Code
  For Each lo_Offer In OfferPrice
    lo_Offer.COF_Id = COF_Id
    lo_Offer.OFD_Type = eDPCPriceBookType.eManualLine
    lo_Offer.PRD_Id = PRD_Id
    lo_Offer.OFD_Pos = OFD_Pos
    Call lo_Collection.Add(lo_Offer)
  Next
  
  Set lo_OfferMain = Nothing
  Set lo_Offer = Nothing
  Set GenerateOfferDetail = lo_Collection
  Exit Function
ErrHandler:
  Call ErrorHandler("GenerateOfferDetail")
End Function

Private Function ReplaceCommonPlaceholders(ByVal as_Request As String) As String
On Error GoTo ErrHandler

  as_Request = Replace(as_Request, "$Z_Creator$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Z_Last_Upd_User$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$Language_Code$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  as_Request = Replace(as_Request, "$COF_Lang$", mo_Tools.SQLStr(ms_Language_Code), , , vbTextCompare)
  ReplaceCommonPlaceholders = as_Request
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceCommonPlaceholders")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub


